// Exp-21 : Design the following FIR filters with the given specification.
//            

////////////////////////////////////////////////////////////////////////
//    Example:
//                 filter type ('lp','hp','sb','bp')
//                 Filter order (pos integer)(odd for ftype='hp' or 'sb')
//                 cfreq=2-vector of cutoff frequencies (0<cfreq(1),cfreq(2)<.5) only cfreq(1) is used when ftype='lp' or 'hp'
//                 wtype= Window type ('re','tr','hm','hn','kr','ch')
//                 fpar=2-vector of window parameters. Kaiser window fpar(1)>0 fpar(2)=0. Chebyshev window fpar(1)>0, fpar(2)<0 or fpar(1)<0, 0<fpar(2)<.5
//                 wft=time domain filter coefficients
//                 wfm=frequency domain filter response on the grid fr
//                 fr=Frequency grid
///////////////////////////////////////////////////////////////////////////

//Evaluate magnitude response of the filter

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7

clc;
close;
clear;

//ftype=input('Enter the Filter Type:','s');
//forder=input('Enter Order of Filter:');
//cfreq=input('Enter Cut-Off Frequency Vector:');
//wtype=input('Enter the Window Type:','s');
//fpar=input('Enter Window Parameter:');

ftype='bp';
forder=33;
fs=8000;
cfreq=[(450/fs) (500/fs)];
wtype='kr';
fpar=[0.8 0];


[wft,wfm,fr]=wfir(ftype,forder,cfreq,wtype,fpar);

clf();
plot(fr,wfm,'b');
title('Frequency Responce','color','red','fontsize', 4);
xlabel("Frequency", "fontsize", 2,"color", "blue");
ylabel("Magnitude", "fontsize", 2, "color", "blue");


